package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Currency {
    RUB("RUB"),
    USD("USD"),
    AMD("AMD"),
    AZN("AZN"),
    BGN("BGN"),
    BYN("BYN"),
    CAD("CAD"),
    CHF("CHF"),
    CNY("CNY"),
    EUR("EUR"),
    GBP("GBP"),
    INR("INR"),
    KGS("KGS"),
    KRW("KRW"),
    KZT("KZT"),
    MDL("MDL"),
    NOK("NOK"),
    PLN("PLN"),
    TJS("TJS"),
    UAH("UAH"),
    UZS("UZS"),
    AUD("AUD");

    private String value;

    Currency(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Currency fromString(String value) {
        for (Currency candidate : Currency.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown currency %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
