package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Email.EmailBuilder.class)
public class Email {

    @PersonalData
    private String emailAddress;

    @JsonPOJOBuilder(withPrefix = "")
    public static class EmailBuilder {
    }
}
