package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ErrorType {
    BOOKING_ALREADY_CANCELLED("95"),
    BOOKING_NOT_FOUND("97"),
    BOOKING_STATUS_INVALID("118"),
    BOOKING_CANNOT_BE_CANCELLED("264"),
    SOLD_OUT("322"),
    HOTEL_IS_INACTIVE("375"),
    HOTEL_NOT_FOUND("392"),
    CACHE_NOT_FOUND("425"),
    UNABLE_TO_PROCESS("450"),
    ARRIVAL_DATE_IS_NOT_AVAILABLE("733"),
    UNKNOWN(null);


    private String code;

    ErrorType(String code) {
        this.code = code;
    }

    @JsonCreator
    public static ErrorType fromString(String value) {
        for (ErrorType candidate : ErrorType.values()) {
            if (candidate.code != null && candidate.code.equals(value)) {
                return candidate;
            }
        }
        return UNKNOWN;
    }

    @JsonValue
    public String getValue() {
        return code;
    }
}
