package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Guest.GuestBuilder.class)
public class Guest {

    @PersonalData
    private String firstName;

    @PersonalData
    private String middleName;

    @PersonalData
    private String lastName;

    private String citizenship;

    private Placement placement;

    @JsonPOJOBuilder(withPrefix = "")
    public static class GuestBuilder {
    }


    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Placement.PlacementBuilder.class)
    public static class Placement {

        private int index;

        @JsonPOJOBuilder(withPrefix = "")
        public static class PlacementBuilder {
        }
    }
}
