package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum GuestPlacementKind {
    ADULT("adult"),
    EXTRA_ADULT("extra_adult"),
    CHILD("child"),
    EXTRA_CHILD("extra_child"),
    CHILD_BAND_WITHOUT_BED("child_band_without_bed");

    private String value;

    GuestPlacementKind(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static GuestPlacementKind fromString(String value) {
        for (GuestPlacementKind candidate : GuestPlacementKind.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown guest placement %s", value)
        );
    }
}
