package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Hotel.HotelBuilder.class)
public class Hotel {

    private String code;

    private String name;

    private String description;

    @Singular
    private List<Image> images;

    private int stars;

    private StayUnitKind stayUnitKind;

    @Singular
    private List<AgeGroup> ageGroups;

    @Singular
    private List<Tax> taxes;

    private Currency currency;

    private ContactInfo contactInfo;

    private Policy policy;

    private Timezone timezone;

    @Singular
    private List<RatePlan> ratePlans;

    @Singular
    private List<RoomType> roomTypes;

    @Singular
    private List<Service> services;

    @Singular
    private Set<BookingMode> bookingModes;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelBuilder {
    }
}
