package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.Value;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
public class HotelChainDetailsResponse extends BaseTravellineResponse {

    private HotelChainDetails hotelChainDetails;

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = HotelChainDetails.HotelChainDetailsBuilder.class)
    public static class HotelChainDetails {

        List<HotelRef> hotelRefs;

        @JsonPOJOBuilder(withPrefix = "")
        public static class HotelChainDetailsBuilder {
        }
    }
}
