package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.Value;

@Data
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class HotelDetails {

    private HotelRef hotelRef;

    private HotelDetailsAddress addressDetails;

    private List<HotelContactInfo> contactInfo;

    private BankAccountDetails bankAccountDetails;

    private HotelOfferStatus offerStatus;

    private LocalDateTime offerUpdatedAt;

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = HotelContactInfo.HotelContactInfoBuilder.class)
    public static class HotelContactInfo {

	    private String name;

	    private String position;

	    private String phone;

	    private String email;

	    private ContactType contactType;

        @JsonPOJOBuilder(withPrefix = "")
        public static class HotelContactInfoBuilder {
        }
    }

    @Data
    @Builder(toBuilder = true)
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class BankAccountDetails {

	    private String personLegalName;

	    private String branchName;

	    private String country;

	    private HotelDetailsAddress addressDetails;

	    private String phone;

	    private String inn;

	    private String kpp;

	    private String bankName;

	    private String bic;

	    private String correspondingAccount;

	    private String currentAccount;

        private TaxType tax;
    }
}
