package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = HotelDetailsAddress.HotelDetailsAddressBuilder.class)
public class HotelDetailsAddress {

    private String postalCode;

    private String country;

    private String region;

    private String cityName;

    private String fullAddress;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelDetailsAddressBuilder {
    }
}
