package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalDate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = HotelInventory.HotelInventoryBuilder.class)
public class HotelInventory {
    private LocalDate date;
    private long version;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelInventoryBuilder {
    }
}
