package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@EqualsAndHashCode(of = {"code"})
@JsonDeserialize(builder = HotelListItem.HotelListItemBuilder.class)
public class HotelListItem {
    private long inventoryVersion;
    private String code;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelListItemBuilder {
    }
}
