package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.Value;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
public class HotelOfferAvailability extends BaseTravellineResponse {

    private List<RoomStay> roomStays;

    private List<RoomTypeQuota> roomTypeQuotas;

    private List<ServiceConditions> services;

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = ServiceConditions.ServiceConditionsBuilder.class)
    public static class ServiceConditions {

        private String rph;

        private String code;

        private boolean inclusive;

        private Price price;

        private Integer quantity;

        @JsonPOJOBuilder(withPrefix = "")
        public static class ServiceConditionsBuilder {
        }
    }
}
