package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum HotelOfferStatus {
    ACCEPTED("accepted"),
    NOT_ACCEPTED("not_accepted"),
    UNKNOWN(null);

    private final String code;

    @JsonCreator
    public static HotelOfferStatus fromString(String value) {
        for (HotelOfferStatus candidate : HotelOfferStatus.values()) {
            if (candidate.code != null && candidate.code.equals(value)) {
                return candidate;
            }
        }
        return UNKNOWN;
    }

    @JsonValue
    public String getValue() {
        return code;
    }
}
