package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum HotelPublicationStatus {
    PUBLISHED("published"),
    NOT_PUBLISHED("not_published"),
    UNKNOWN(null);

    private final String code;

    @JsonCreator
    public static HotelPublicationStatus fromString(String value) {
        for (HotelPublicationStatus candidate : HotelPublicationStatus.values()) {
            if (candidate.code != null && candidate.code.equals(value)) {
                return candidate;
            }
        }
        return UNKNOWN;
    }

    @JsonValue
    public String getValue() {
        return code;
    }
}
