package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = HotelReservation.HotelReservationBuilder.class)
public class HotelReservation {

    private HotelRef hotelRef;

    private String yandexNumber;

    private List<ReservationServiceReference> services;

    @Singular
    private List<ReservationRoomStay> roomStays;

    private Customer customer;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelReservationBuilder {
    }
}
