package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.travelline.model.dto.OfferDto;
import ru.yandex.travel.hotels.common.partners.travelline.utils.RequestHelper;


@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = HotelReservationRequest.HotelReservationRequestBuilder.class)
public class HotelReservationRequest {
    private String language;
    private Currency currency;

    @Singular
    private List<HotelReservation> hotelReservations;

    public static HotelReservationRequest create(@Nonnull OfferDto offerDto,
                                                 int placementIndex,
                                                 @Nullable String yandexId,
                                                 @Nullable List<ru.yandex.travel.hotels.common.orders.Guest> guests,
                                                 @Nullable String customerPhone,
                                                 @Nullable String customerEmail) {
        return HotelReservationRequest.builder()
                .currency(Currency.RUB)
                .language("ru-ru")
                .hotelReservation(
                        RequestHelper.createHotelReservation(offerDto, placementIndex, Collections.emptyList(),
                                yandexId, guests, customerPhone, customerEmail))
                .build();
    }


    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelReservationRequestBuilder {
    }
}
