package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.travel.hotels.proto.EPansionType;

public enum MealPlanType {

    ALL_INCLUSIVE("all_inclusive", EPansionType.PT_AI),
    ULTRA_ALL_INCLUSIVE("ultra_all_inclusive", EPansionType.PT_UAI),
    BUFFET_BREAKFAST("buffet_breakfast", EPansionType.PT_BB),
    CONTINENTAL_BREAKFAST("continental_breakfast", EPansionType.PT_BB),
    ENGLISH_BREAKFAST("english_breakfast", EPansionType.PT_BB),
    AMERICAN_BREAKFAST("american_breakfast", EPansionType.PT_BB),
    FULL_BOARD("full_board", EPansionType.PT_FB),
    HALF_BOARD("half_board", EPansionType.PT_HB),
    BREAKFAST("breakfast", EPansionType.PT_BB),
    LUNCH("lunch", EPansionType.PT_BB), //TODO no correct mapping for lunch
    DINNER("dinner", EPansionType.PT_BD),
    BREAKFAST_AND_LUNCH("breakfast_and_lunch", EPansionType.PT_BB), // TODO (tivelkov): no correct mapping
    BREAKFAST_AND_DINNER("dinner_bed_and_breakfast_plan", EPansionType.PT_HB),
    HALF_BOARD_LUNCH_DINNER("half_board_lunch_dinner", EPansionType.PT_BD),
    UNKNOWN("unknown", EPansionType.PT_UNKNOWN);

    private String value;

    private EPansionType ePansionType;

    MealPlanType(String value, EPansionType ePansionType) {
        this.value = value;
        this.ePansionType = ePansionType;
    }

    public EPansionType getEPansionType() {
        return ePansionType;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static MealPlanType fromString(String value) {
        for (MealPlanType candidate : MealPlanType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown meal plan type %s", value)
        );
    }
}
