package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum MeasureUnitCode {
    SQUARE_METRE("square_metre");

    private String value;

    MeasureUnitCode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static MeasureUnitCode fromString(String value) {
        for (MeasureUnitCode candidate : MeasureUnitCode.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown measure unit code %s", value)
        );
    }
}
