package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Phone.PhoneBuilder.class)
public class Phone {

    @PersonalData
    private String phoneNumber;

    private String remark;

    private String techType;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PhoneBuilder {
    }
}
