package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Placement.PlacementBuilder.class)
public class Placement {

    private int index;

    private double priceBeforeTax;

    private GuestPlacementKind kind;

    private String code;

    private int capacity;

    private Currency currency;

    @Singular
    private List<Tax> taxes;

    private Integer ageGroup;

    @Singular
    private List<PlacementRate.Rate> rates;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PlacementBuilder {
    }
}
