package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PlacementRate.PlacementRateBuilder.class)
public class PlacementRate {

    private String roomTypeCode;

    private String ratePlanCode;

    private PlacementRef placement;

    @Singular
    private List<Rate> rates;

	@JsonPOJOBuilder(withPrefix = "")
    public static class PlacementRateBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Rate.RateBuilder.class)
    public static class Rate {

	    private LocalDate date;

	    private Double priceBeforeTax;

	    private Currency currency;

	    @JsonPOJOBuilder(withPrefix = "")
        public static class RateBuilder {
        }
    }
}
