package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PlacementRef.PlacementRefBuilder.class)
public class PlacementRef {

    private int index;

    private GuestPlacementKind kind;

    private String code;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PlacementRefBuilder {
    }
}
