package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Policy.PolicyBuilder.class)
public class Policy {

    private LocalTime checkInTime;

    private LocalTime checkOutTime;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PolicyBuilder {
    }
}
