package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Price.PriceBuilder.class)
public class Price {

    private double priceBeforeTax;

    private double priceAfterTax;

    private Currency currency;

    @JsonPOJOBuilder(withPrefix = "")
    public static class PriceBuilder {
    }
}
