package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.Set;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RatePlan.RatePlanBuilder.class)
public class RatePlan {

    private String code;

    private String name;

    private String description;

    private String shortDescription;

    private Currency currency;

    private RatePlanKind kind;

    private Set<String> sources;

    private boolean withChildrenOnly;

    private boolean treatment;

    private VatTaxType vatTaxType;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RatePlanBuilder {
    }
}
