package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum RatePlanKind {
    COMMON("common"),
    SHARED("shared"),
    UNKNOWN("unknown");


    private final String value;

    RatePlanKind(String value) {
        this.value = value;
    }

    @JsonCreator
    public static RatePlanKind fromString(String value) {
        for (var candidate : RatePlanKind.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown RatePlanKind %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
