package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ReservationRoomStay.ReservationRoomStayBuilder.class)
public class ReservationRoomStay {

    private StayDates stayDates;

    @Singular
    private List<ReservationRoomType> roomTypes;

    @Singular
    private List<RatePlan> ratePlans;

    private GuestCountInfo guestCountInfo;

    @Singular
    private List<ReservationServiceReference> services;

    private List<Guest> guests;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ReservationRoomStayBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = RatePlan.RatePlanBuilder.class)
    public static class RatePlan {

        private String code;

        @JsonPOJOBuilder(withPrefix = "")
        public static class RatePlanBuilder {
        }
    }

}
