package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ReservationRoomType.ReservationRoomTypeBuilder.class)
public class ReservationRoomType {

    private String code;

    private List<PlacementRef> placements;

    private List<Preference> preferences;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ReservationRoomTypeBuilder {
    }
}
