package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RespHotelReservation.RespHotelReservationBuilder.class)
public class RespHotelReservation {

    private String reservationNumber;

    private String yandexNumber;

    private BookingStatus status;

    private HotelRef hotelRef;

    private Total total;

    private LocalDateTime createDate;

    private LocalDateTime lastModificationDate;

    private String language;

    private Customer customer;

    @Singular
    private List<ResponseRoomStay> roomStays;

    private CancellationInfo cancellationInfo;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RespHotelReservationBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = HotelRef.HotelRefBuilder.class)
    public static class HotelRef {

        private String code;

        private String name;

        @JsonPOJOBuilder(withPrefix = "")
        public static class HotelRefBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Total.TotalBuilder.class)
    public static class Total {

        private double priceBeforeTax;

        private double priceAfterTax;

        private Currency currency;

        private List<Tax> taxes;

        @JsonPOJOBuilder(withPrefix = "")
        public static class TotalBuilder {
        }
    }
}

