package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ResponseRoomStay.ResponseRoomStayBuilder.class)
public class ResponseRoomStay {

    private List<Guest> guests;

    private GuestCountInfo guestCountInfo;

    private List<ResponseRoomType> roomTypes;

    @Singular
    private List<RatePlan> ratePlans;

    private Total stayTotal;

    private Total total;

    private List<Service> services;

    private StayDates stayDates;

    private CancelPenaltyGroup cancelPenaltyGroup;

    private List<PlacementRate> placementRates;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ResponseRoomStayBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Guest.GuestBuilder.class)
    public static class Guest {

        private String ref;

        private int count;

        @PersonalData
        private String firstName;

        @PersonalData
        private String lastName;

        @PersonalData
        private String middleName;

        private Placement placement;

        private String citizenship;

        private String city;

        private String region;

        @PersonalData
        private String postalCode;

        @JsonPOJOBuilder(withPrefix = "")
        public static class GuestBuilder {
        }

    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = GuestCountInfo.GuestCountInfoBuilder.class)
    public static class GuestCountInfo {

        private int adults;

        private int children;

        private List<GuestCount> guestCounts;

        @JsonPOJOBuilder(withPrefix = "")
        public static class GuestCountInfoBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Total.TotalBuilder.class)
    public static class Total {

        private double priceBeforeTax;

        private double priceAfterTax;

        private Currency currency;

        private List<Tax> taxes;

        @JsonPOJOBuilder(withPrefix = "")
        public static class TotalBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Service.ServiceBuilder.class)
    public static class Service {

        private String code;

        private String name;

        private String description;

        private Price price;

        private ServiceKind kind;

        private MealPlanType mealPlanType;

        private ChargeType chargeType;

        private boolean inclusive;

        private int quantity;

        private VatTaxType vatTaxType;

        @JsonPOJOBuilder(withPrefix = "")
        public static class ServiceBuilder {
        }
    }
}
