package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ResponseRoomType.ResponseRoomTypeBuilder.class)
public class ResponseRoomType {

    private List<Placement> placements;

    private String code;

    private String name;

    private RoomTypeUnitKind kind;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ResponseRoomTypeBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Placement.PlacementBuilder.class)
    public static class Placement {

        private int index;

        private int ratePlanCode;

        private double priceBeforeTax;

        private double priceAfterTax;

        private GuestPlacementKind kind;

        private String code;

        private int capacity;

        private Currency currency;

        @JsonPOJOBuilder(withPrefix = "")
        public static class PlacementBuilder {
        }
    }
}
