package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomStay.RoomStayBuilder.class)
public class RoomStay {

    private HotelRef hotelRef;

    @Singular
    private List<RoomTypeRef> roomTypes;

    @Singular
    private List<RatePlanRef> ratePlans;

    private StayDates stayDates;

    @Singular
    private List<ServiceRef> services;

    @Singular
    private List<PlacementRate> placementRates;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomStayBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = RoomTypeRef.RoomTypeRefBuilder.class)
    public static class RoomTypeRef {

        private String code;

        private String roomTypeQuotaRph;

        private List<Placement> placements;

        @JsonPOJOBuilder(withPrefix = "")
        public static class RoomTypeRefBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = RatePlanRef.RatePlanRefBuilder.class)
    public static class RatePlanRef {

        private String code;

        private CancelPenaltyGroup cancelPenaltyGroup;

        @JsonPOJOBuilder(withPrefix = "")
        public static class RatePlanRefBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = ServiceRef.ServiceRefBuilder.class)
    public static class ServiceRef {

        private String rph;

        @JsonPOJOBuilder(withPrefix = "")
        public static class ServiceRefBuilder {
        }
    }
}
