package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomType.RoomTypeBuilder.class)
public class RoomType {

    private String code;

    private String name;

    private String description;

    private List<Amenity> amenities;

    @Singular
    private List<Image> images;

    private RoomTypeUnitKind kind;

    private int maxOccupancy;

    private int maxAdultOccupancy;

    private int maxExtraBedOccupancy;

    private int maxWithoutBedOccupancy;

    private RoomTypeSquare size;

    private ContactInfo contactInfo;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomTypeBuilder {
    }
}
