package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum RoomTypeUnitKind {
    ROOM("room"),
    PLACE_IN_ROOM("place_in_room"),
    COTTAGE("cottage"),
    APARTMENT("apartment");

    private String value;

    RoomTypeUnitKind(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static RoomTypeUnitKind fromString(String value) {
        for (RoomTypeUnitKind candidate : RoomTypeUnitKind.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown room type unit %s", value)
        );
    }
}
