package ru.yandex.travel.hotels.common.partners.travelline.model;


import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Service.ServiceBuilder.class)
public class Service {

    private String code;

    private String name;

    private String description;

    private ServiceKind kind;

    private MealPlanType mealPlanType;

    private ChargeType chargeType;

    private List<Image> images;

    private Integer quantity;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ServiceBuilder {
    }
}
