package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.time.LocalDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = StayDates.StayDatesBuilder.class)
public class StayDates {

    private LocalDateTime startDate;

    private LocalDateTime endDate;

    @JsonPOJOBuilder(withPrefix = "")
    public static class StayDatesBuilder {
    }
}
