package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum StayUnitKind {
    DAY("day"),
    NIGHT("night");

    private final String value;

    StayUnitKind(String value) {
        this.value = value;
    }

    @JsonCreator
    public static StayUnitKind fromString(String value) {
        for (var candidate : StayUnitKind.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown StayUnitKind %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
