package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Tax.TaxBuilder.class)
public class Tax {

    private String code;

    private String name;

    private String description;

    private String kind;

    private Double amount;

    @JsonPOJOBuilder(withPrefix = "")
    public static class TaxBuilder {
    }
}
