package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum TaxType {
    COMMON("common"),
    COMMON_WITHOUT_VAT("common_without_vat"),
    COMMON_0_VAT("common_0_vat"),
    SIMPLE_INCOME("simple_income"),
    SIMPLE_INCOME_OUTLAY("simple_income_outlay"),
    UNIFIED_ON_TEMPORARY_INCOME("unified_on_temporary_income"),
    UNIFORM_AGRICULTURAL("uniform_agricultural"),
    PATENT("patent");

    private final String code;

    @JsonCreator
    public static TaxType fromString(String value) {
        for (TaxType candidate : TaxType.values()) {
            if (candidate.code != null && candidate.code.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown tax type %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return code;
    }
}
