package ru.yandex.travel.hotels.common.partners.travelline.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.travel.orders.commons.proto.EVat;

public enum VatTaxType {
    NONE("none"),
    VAT0("vat0"),
    VAT10("vat10"),
    VAT18("vat18"),
    VAT110("vat110"),
    VAT118("vat118"),
    VAT120("vat120"),
    VAT20("vat20"),
    VAT12("vat12");


    private final String code;

    VatTaxType(String code) {
        this.code = code;
    }

    @JsonValue
    public String getCode() {
        return code;
    }

    @JsonCreator
    public static VatTaxType fromString(String value) {
        for (VatTaxType candidate : VatTaxType.values()) {
            if (candidate.code.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown vat tax type %s", value)
        );
    }

    public EVat toProto() {
        switch (this) {
            case NONE:
                return EVat.VAT_NONE;
            case VAT0:
                return EVat.VAT_0;
            case VAT10:
                return EVat.VAT_10;
            case VAT18:
                return EVat.VAT_18;
            case VAT110:
                return EVat.VAT_10_110;
            case VAT118:
                return EVat.VAT_18_118;
            case VAT120:
                return EVat.VAT_20_120;
            case VAT20:
                return EVat.VAT_20;
            default:
                throw new IllegalArgumentException(String.format("Unsupported vat value %s", this.code));
        }
    }
}
