package ru.yandex.travel.hotels.common.partners.travelline.model;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.travelline.model.dto.OfferDto;
import ru.yandex.travel.hotels.common.partners.travelline.utils.RequestHelper;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = VerifyReservationRequest.VerifyReservationRequestBuilder.class)
public class VerifyReservationRequest {

    private String language;

    private Currency currency;

    @Singular
    private List<HotelReservation> hotelReservations;

    public static VerifyReservationRequest create(OfferDto offerDto, int placementIndex) {
        return VerifyReservationRequest.builder()
                .currency(Currency.RUB)
                .language("ru-ru")
                .hotelReservation(
                        RequestHelper.createHotelReservation(offerDto, placementIndex, Collections.emptyList(), null, null, null, null))
                .build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class VerifyReservationRequestBuilder {
    }
}
