package ru.yandex.travel.hotels.common.partners.travelline.model.dto;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.travelline.model.ContactInfo;
import ru.yandex.travel.hotels.common.partners.travelline.model.Image;
import ru.yandex.travel.hotels.common.partners.travelline.model.Policy;
import ru.yandex.travel.hotels.common.partners.travelline.model.StayUnitKind;
import ru.yandex.travel.hotels.common.partners.travelline.model.Timezone;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = HotelDto.HotelDtoBuilder.class)
public class HotelDto {
    private String code;
    private String name;
    private String description;
    private List<Image> images;
    private int stars;
    private ContactInfo contactInfo;
    private Policy policy;
    private Timezone timezone;
    private StayUnitKind stayUnitKind;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelDtoBuilder{
    }
}
