package ru.yandex.travel.hotels.common.partners.travelline.model.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.travelline.model.HotelOfferAvailability;
import ru.yandex.travel.hotels.common.partners.travelline.model.Service;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ServiceDto.ServiceDtoBuilder.class)
public class ServiceDto {
    private Service info;
    private HotelOfferAvailability.ServiceConditions conditions;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ServiceDtoBuilder {
    }
}
