package ru.yandex.travel.hotels.common.partners.travelline.placements;

import java.util.List;

import lombok.Value;

@Value
public class Allocation {
    private int primaryAdults;
    private List<Integer> primaryChildrenIndexes;
    private int extraAdults;
    private List<Integer> extraChildrenIndexes;
    private List<Integer> childrenWithNoPlaceIndexes;

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("O".repeat(primaryAdults));
        builder.append("o".repeat(primaryChildrenIndexes.size()));
        if (extraAdults + extraChildrenIndexes.size() + childrenWithNoPlaceIndexes.size() > 0) {
            builder.append("+");
        }
        builder.append("O".repeat(extraAdults));
        builder.append("o".repeat(extraChildrenIndexes.size()));
        builder.append("c".repeat(childrenWithNoPlaceIndexes.size()));
        return builder.toString();
    }

    public Key getKey() {
        return new Key(primaryAdults, primaryChildrenIndexes.size(), extraAdults, extraChildrenIndexes.size(),
                childrenWithNoPlaceIndexes.size());
    }

    @Value
    public static class Key {
        private int primaryAdults;
        private int primaryChildren;
        private int extraAdults;
        private int extraChildren;
        private int childrenWithNoPlaces;

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("O".repeat(primaryAdults));
            builder.append("o".repeat(primaryChildren));
            if (extraAdults + extraChildren + childrenWithNoPlaces > 0) {
                builder.append("+");
            }
            builder.append("O".repeat(extraAdults));
            builder.append("o".repeat(extraChildren));
            builder.append("c".repeat(childrenWithNoPlaces));
            return builder.toString();
        }
    }
}
