package ru.yandex.travel.hotels.common.partners.travelline.placements;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import lombok.Data;
import lombok.Getter;

import ru.yandex.travel.hotels.common.token.Occupancy;

@Data
public class Guest {
    @Getter
    private boolean isAdult;
    @Getter
    private Integer age;
    @Getter
    private int index;

    private Guest(int index, boolean isAdult, Integer age) {
        this.index = index;
        this.isAdult = isAdult;
        this.age = age;
    }

    public static List<Guest> fromOccupancy(Occupancy occupancy) {
        List<Guest> res = new ArrayList<>();
        for (int i = 0; i < occupancy.getAdults(); i++) {
            res.add(new Guest(i, true, null));
        }
        int j = occupancy.getAdults();
        for (int childAge : occupancy.getChildren()) {
            res.add(new Guest(j, false, childAge));
            j++;
        }
        return res;
    }

    public static Guest empty() {
        return new Guest(-1, false, null);
    }

    public boolean isEmpty() {
        return index == -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Guest occupant = (Guest) o;
        return isAdult == occupant.isAdult &&
                index == occupant.index &&
                Objects.equals(age, occupant.age);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isAdult, age, index);
    }
}
