package ru.yandex.travel.hotels.common.partners.travelline.placements;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.travelline.model.GuestCountInfo;
import ru.yandex.travel.hotels.common.partners.travelline.model.Placement;
import ru.yandex.travel.hotels.common.refunds.RefundRules;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PlacementSet.PlacementSetBuilder.class)
public class PlacementSet {
    private List<Placement> placements;
    private GuestCountInfo guestCountInfo;
    private List<Integer> guestPlacementIndexes;
    private RefundRules refundRules;

    @JsonIgnore
    public double getTotalCost() {
        return placements.stream().map(Placement::getPriceBeforeTax).reduce(0d, Double::sum);
    }

    @JsonPOJOBuilder(withPrefix = "")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class PlacementSetBuilder {
    }
}
