package ru.yandex.travel.hotels.common.partners.travelline.utils;

import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.travel.hotels.common.partners.travelline.model.Address;
import ru.yandex.travel.hotels.common.partners.travelline.model.Hotel;
import ru.yandex.travel.hotels.common.partners.travelline.model.RoomType;

@Slf4j
public class RoomMatchingHelper {
    public static boolean checkRoomMatchesHotel(RoomType room, Hotel hotel) {
        if (room.getContactInfo() == null || room.getContactInfo().getAddresses() == null ||
                room.getContactInfo().getAddresses().isEmpty() || hotel.getContactInfo() == null ||
                hotel.getContactInfo().getAddresses() == null) {
            return true;
        }
        if (room.getContactInfo().getAddresses().size() != hotel.getContactInfo().getAddresses().size()) {
            return mismatch(room, hotel, "number of addresses do not match");
        }
        for (int i = 0; i < room.getContactInfo().getAddresses().size(); i++) {
            var roomAddr = normalize(room.getContactInfo().getAddresses().get(i));
            var hotelAddr = normalize(hotel.getContactInfo().getAddresses().get(i));
            if (!roomAddr.equals(hotelAddr)) {
                return mismatch(room, hotel,
                        String.format("%s is not the same as %s", roomAddr.toString(), hotelAddr.toString()));
            }
        }
        return true;
    }

    private static Address normalize(Address source) {
        return source.toBuilder()
                .remark(null)
                .latitude(0)
                .longitude(0)
                .addressLine(source.getAddressLine().stream()
                        .filter(StringUtils::isNotBlank)
                        .map(s -> s.replace(".,", "."))
                        .collect(Collectors.toList()))
                .build();
    }

    private static boolean mismatch(RoomType room, Hotel hotel, String reason) {
        log.warn("Room {} does not match hotel {}: {}", room.getCode(), hotel.getCode(), reason);
        return false;
    }
}
