package ru.yandex.travel.hotels.common.partners.tvil;

import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.common.partners.tvil.model.TvilSearchRequest;
import ru.yandex.travel.hotels.common.partners.tvil.model.TvilSearchResponse;

import static ru.yandex.travel.hotels.common.partners.base.Helpers.sync;

public interface TvilClient {
    CompletableFuture<TvilSearchResponse> searchOffers(TvilSearchRequest request);

    default TvilSearchResponse searchOffersSync(TvilSearchRequest request) {
        return sync(searchOffers(request));
    }
}
