package ru.yandex.travel.hotels.common.partners.tvil.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
@JsonDeserialize(builder = TvilOffer.TvilOfferBuilder.class)
public class TvilOffer {
    @JsonProperty("url")
    private String url;

    @JsonProperty("name")
    private String name;

    @JsonProperty("breakfast")
    private Boolean breakfast;

    @JsonProperty("smoking")
    private Boolean smoking;

    @JsonProperty("refundable")
    private Boolean refundable;

    @JsonProperty("available")
    private Integer available;

    @JsonProperty("price")
    private BigDecimal price;

    @JsonProperty("room_id")
    private Integer roomId;

    @JsonProperty("room_type_id")
    private Integer roomTypeId;

    @JsonProperty("eating")
    private String eating;

    @JsonPOJOBuilder(withPrefix = "")
    public static class TvilOfferBuilder {
    }
}
