package ru.yandex.travel.hotels.common.partners.tvil.model;

import java.time.LocalDate;
import java.util.List;
import java.util.Set;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TvilSearchRequest {
    private Set<String> hotelIds;
    private LocalDate checkIn;
    private LocalDate checkOut;
    private List<TvilGuests> guests;
    private String language;
    private String currency;
    private String userCountry;
    private String requestId;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TvilGuests {
        private Integer adults;
        private List<Integer> childrenAges;
    }
}
